 ; Pollar - modify the segment widths in a standard polyline at
 ; one end only.
 ; Polo - set all to zero.
 ; Pol - Pollar, variable width and number of repeats.
 ; Copyright 2003, 2004, 2005 by Rocket Software Ltd.
 ; Rocket - Useful Software for Useful - hang on a second...

 (DEFUN POLLAR (enam widd / entt)
  (setq entt (entget enam))
  (while (/= (cdr (assoc 0 entt)) "SEQEND")
         (entmod (setq entt (subst (cons 40 widd) (assoc 40 entt) entt)))
         (entmod (subst (cons 41 0) (assoc 41 entt) entt))
         (setq entt (entget (setq enam (entnext enam))))
         (entupd enam))
 (princ))

 (DEFUN C:POL (/ entt enam widd wsave reps)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq enam (car (entsel "Polyline:\n")))
  (if (= (cdr (assoc 0 (entget enam))) "POLYLINE")
      (progn
           (setq widd (getreal "Width: "))
           (setq wsave widd)
           (setq reps (getint "Repeats: "))
           (repeat reps
                  (pollar enam widd)
                  (setq widd (+ widd wsave))))
      (write-line "That was not a polyline."))
  (command "undo" "e")
 (princ))

 (DEFUN C:POLO (/ enam)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq enam (car (entsel "Polyline:\n")))
  (if (= (cdr (assoc 0 (entget enam))) "POLYLINE")
      (pollar enam 0)
      (write-line "That was not a polyline."))
  (command "undo" "e")
 (princ))

 (DEFUN C:POLLAR (/ enam widd)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq enam (car (entsel "Polyline:\n")))
  (if (= (cdr (assoc 0 (entget enam))) "POLYLINE")
      (progn
           (setq widd (getreal "Width: "))
           (pollar enam widd))
      (write-line "That was not a polyline."))
  (command "undo" "e")
 (princ))